'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 15 June 2005 at 5:04:15 pm'!
SmartSyntaxInterpreterPlugin subclass: #SpellingPlugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VMMaker-Plugins'!

!SpellingPlugin methodsFor: 'initialize' stamp: 'JMM 6/14/2005 10:16'!
initialiseModule
	self export: true.
	^self sqSpellingInitialize ! !

!SpellingPlugin methodsFor: 'initialize' stamp: 'JMM 6/14/2005 10:16'!
moduleUnloaded: aModuleName 
	"The module with the given name was just unloaded. 
	Make sure we have no dangling references."
	self export: true.
	self var: #aModuleName type: 'char *'.
	(aModuleName strcmp: 'SpellingPlugin') = 0
		ifTrue: [self sqSpellingShutdown]! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/15/2005 16:44'!
primitiveCheckSpelling: data startingAt: anInteger
	"data is? Tag that identifies document/image"

	| resultPtr result arrayOop value length |
	self var: #result declareC: 'int result[2]'.
	self var: #resultPtr declareC: 'int * resultPtr=result'.
	self primitive: 'primitiveCheckSpelling' parameters:#(Oop SmallInteger).
	length := interpreterProxy stSizeOf: data.
	self sqSpellingCheckSpelling: (interpreterProxy firstIndexableField: data) startingAt: anInteger - 1 length: length/2 results: resultPtr.
	arrayOop := interpreterProxy
		instantiateClass: interpreterProxy classArray
		indexableSize: 2.
	0 to: 1 do:[:i|
		interpreterProxy pushRemappableOop: arrayOop.
		value := interpreterProxy positive32BitIntegerFor: (result at: i).
		arrayOop := interpreterProxy popRemappableOop.
		interpreterProxy storePointer: i ofObject: arrayOop withValue: value].
	^arrayOop
! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/15/2005 14:51'!
primitiveGetGuessesForWordListLength: data withTag: aTag
	"data is? Tag that identifies document/image"

	| size length |
	self primitive: 'primitiveGetGuessesForWordListLength' parameters:#(Oop SmallInteger).
	length := interpreterProxy stSizeOf: data.
	size := self sqSpellingGuessForWordListLength: (interpreterProxy firstIndexableField: data) withTag: aTag length: length/2.

	^size asSmallIntegerObj! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 22:07'!
primitiveGetGuessesForWordwithTag: aTag at: index
	"data is? Tag that identifies document/image"

	| length oop |
	self primitive: 'primitiveGetGuessesForWordwithTag' parameters:#(SmallInteger SmallInteger).
	length := self sqSpellingGuessForWordwithTagLength: aTag at: index-1.
	oop := interpreterProxy instantiateClass: interpreterProxy classByteArray indexableSize: length*2.
	self sqSpellingGuessForWordwithTag: aTag at: index-1 into: (interpreterProxy firstIndexableField: oop).
	^oop
! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 16:14'!
primitiveGetIgnoredWordsListLengthWithTag: aTag
	"Get ignored word list"
	| length |

	self primitive: 'primitiveGetIgnoredWordsListLengthWithTag'  parameters:#(SmallInteger).
	length := self sqSpellingGetIgnoredWordsListLengthWithTag: aTag.
	^length asSmallIntegerObj! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 22:06'!
primitiveGetIgnoredWordWithTag: aTag at: anIndex
	"Get ignored word list"
	| length oop |

	self primitive: 'primitiveGetIgnoredWordWithTag'  parameters:#(SmallInteger SmallInteger).
	length := self sqSpellingGetIgnoredWordLengthWithTag: aTag at: anIndex-1.
	oop := interpreterProxy instantiateClass: interpreterProxy classByteArray indexableSize: length*2.
	self sqSpellingGetIgnoredWordWithTag: aTag at: anIndex-1 into: (interpreterProxy firstIndexableField: oop).
	^oop! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 17:49'!
primitiveGetLanguage
	"Return Language"
	| length oop |

	self primitive: 'primitiveGetLanguage'.
	length := self sqSpellingGetLanguageLength.
	oop := interpreterProxy instantiateClass: interpreterProxy classString indexableSize: length.
	self sqSpellingGetLanguageInto: (interpreterProxy firstIndexableField: oop).
	^oop
! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 17:50'!
primitiveGetUniqueSpellingTag
	"Return Tag that identifies document/image"
	| tag |

	self primitive: 'primitiveGetUniqueSpellingTag'.
	tag := self sqSpellingGetUniqueSpellingTag.
	^tag asOop: SmallInteger
! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 17:50'!
primitiveSetIgnoredWordsListLength: length withTag: aTag
	"data is? Tag that identifies document/image"

	self primitive: 'primitiveSetIgnoredWordsListLength' parameters:#(SmallInteger SmallInteger).
	self sqSpellingSetIgnoredWordsListLength: length withTag: aTag! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 21:56'!
primitiveSetIgnoredWords: data withTag: aTag at: anIndex
	"data is? Tag that identifies document/image"

	self primitive: 'primitiveSetIgnoredWords' parameters:#(Oop SmallInteger SmallInteger).
	self sqSpellingSetIgnoredWord: (interpreterProxy firstIndexableField: data) withTag: aTag at: anIndex - 1 length: (interpreterProxy stSizeOf: data)/2
! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 21:52'!
primitiveSetLanguage: data 
	"data is? "

	self primitive: 'primitiveSetLanguage' parameters:#(Oop).
	self sqSpellingSetLanguage: (interpreterProxy firstIndexableField: data) length: (interpreterProxy stSizeOf: data)
! !

!SpellingPlugin methodsFor: 'system primitives' stamp: 'JMM 6/14/2005 21:55'!
primitiveSetNewIgnoredWord: data withTag: aTag
	"data is? Tag that identifies document/image"

	self primitive: 'primitiveSetNewIgnoredWord' parameters:#(Oop SmallInteger).
	self sqSpellingSetNewIgnoredWord: (interpreterProxy firstIndexableField: data) withTag: aTag length: (interpreterProxy stSizeOf: data)/2
! !


!SpellingPlugin class methodsFor: 'translation' stamp: 'JMM 6/14/2005 10:17'!
hasHeaderFile
	"If there is a single intrinsic header file to be associated with the plugin, here is where you want to flag"
	^true! !

!SpellingPlugin class methodsFor: 'translation' stamp: 'JMM 6/14/2005 10:17'!
requiresPlatformFiles
	"this plugin requires platform specific files in order to work"
	^true! !


!SpellingPlugin class reorganize!
('translation' hasHeaderFile requiresPlatformFiles)
!

SpellingPlugin removeSelector: #primitiveGetGuessesForWordLength:withTag:!
SpellingPlugin removeSelector: #primitiveGetIgnoredWordListLengthWithTag:!
SpellingPlugin removeSelector: #primitiveGetIgnoredWordListWithTag:!
SpellingPlugin removeSelector: #primitiveGetIgnoredWordsListWithTag:at:!
SpellingPlugin removeSelector: #primitiveGuessesForWord:withTag:!
SpellingPlugin removeSelector: #primitiveLanguage:!
SpellingPlugin removeSelector: #primitiveSetIgnoredWordsLength:forTag:!
SpellingPlugin removeSelector: #primitiveSetIgnoredWords:withTag:!
SpellingPlugin removeSelector: #primitiveSetIgnoredWord:withTag:!
SpellingPlugin removeSelector: #primitiveSetIgnoredWord:withTag:at:!

!SpellingPlugin reorganize!
('initialize' initialiseModule moduleUnloaded:)
('system primitives' primitiveCheckSpelling:startingAt: primitiveGetGuessesForWordListLength:withTag: primitiveGetGuessesForWordwithTag:at: primitiveGetIgnoredWordsListLengthWithTag: primitiveGetIgnoredWordWithTag:at: primitiveGetLanguage primitiveGetUniqueSpellingTag primitiveSetIgnoredWordsListLength:withTag: primitiveSetIgnoredWords:withTag:at: primitiveSetLanguage: primitiveSetNewIgnoredWord:withTag:)
!

